#include <iostream>

template <unsigned int n, unsigned int p>
struct _div_loop {
	static const bool value = (n % p != 0) && _div_loop <n, p - 1>::value;
};

template <unsigned int n>
struct _div_loop <n, 1> {
	static const bool value = 1;
};

template <unsigned int n>
struct is_prime {
	static const bool value = _div_loop <n, n - 1>::value;
};

template <>
struct is_prime <1> {
	static const bool value = false;
};

int main (void) {
	std::cout << is_prime <10>::value << std::endl;
	return 0;
}