#define BOOST_TEST_MODULE example
#include <boost/test/included/unit_test.hpp>

boost::test_tools::predicate_result is_even( int i )
{ 
    if (i % 2 != 0) {
       boost::test_tools::predicate_result res( false);
       res.message() << "Hello from is_even! :)";
       return res;
    }
    return true;
}

boost::test_tools::predicate_result is_sum_even( int i, int j )
{ 
    if ( (i + j) % 2 == 0) {
       boost::test_tools::predicate_result res( false);
       res.message() << "Hello from is_sum_even! :)";
       return res;
    }
    return true;
}

BOOST_AUTO_TEST_CASE( test_is_even )
{
    BOOST_CHECK_PREDICATE( is_even, (14) );
    BOOST_CHECK_PREDICATE( is_even, (17) );

    BOOST_CHECK( is_sum_even(17, 13) );
    BOOST_CHECK( is_sum_even(18, 13) );
}
